﻿using System;
using System.Collections; //Namespace für ArrayList!

class Program
{
    static void Main(string[] args)
    {
        Console.WriteLine("Wir legen ein (festes) Integer-Array an.");
        //direkte Initialisierung
        int[] simple1 = new int[] { 1, 2, 4, 8, 16 };

        //oder nur mit Startgröße
        int[] simple2 = new int[5];
        simple2[0] = 1;
        //auch für arrays gibt es Eigenschaften wie Length (OOP)
        for (int i = 1; i < simple2.Length; i++)
            simple2[i] = simple2[i - 1] * 2;

        foreach (int simple in simple1)
            Console.WriteLine("Eintrag(1) ist " + simple);

        foreach (int simple in simple1)
            Console.WriteLine("Eintrag(2) ist " + simple);

        Console.WriteLine("Wir legen ein (dynamisches) Double-Array an.");
        //Wir arbeiten mit der auf Objects basierenden ArrayList
        ArrayList dyn = new ArrayList();
        dyn.Add(1.1);
        dyn.Add(10.01);
        dyn.Add(100.001);

        foreach (double d in dyn)
            Console.WriteLine("Eintrag(3) ist " + d);

        Console.WriteLine("Wir legen ein mehrdimensionales (festes) Double-Array an.");
        double[,] complex = new double[4, 2];
        complex[0, 0] = 1.0;
        complex[0, 1] = 0.0;
        complex[1, 0] = 0.0;
        complex[1, 1] = 1.0;
        complex[2, 0] = -1.0;
        complex[2, 1] = 0.0;
        complex[3, 0] = 0.0;
        complex[3, 1] = -1.0;

        foreach(double d in complex)
            Console.WriteLine("Eintrag(4) ist " + d);

        Console.WriteLine("Andere Ansicht dieses Arrays.");

        for(int i = 0; i < complex.GetLength(0); i++)
            Console.WriteLine("Eintrag(5) ist " + complex[i, 0] + " + i * " + complex[i, 1]);

        Console.WriteLine("Wir legen ein mehrdimensionales, verzweigtes (festes) Double-Array an.");
        //ein Array von (double[]) - d.h. (double[])[] == double[][]
        double[][] jagged = new double[2][];
        //Also: erstellt 2 Zeilen - erste Zeile hat 5 Spalten, zweite Zeile hat 3 Spalten
        jagged[0] = new double[5];
        jagged[1] = new double[3];
        Random ran = new Random();

        for (int i = 0; i < jagged.Length; i++)
            for (int j = 0; j < jagged[i].Length; j++)
            {
                jagged[i][j] = ran.NextDouble();
                Console.WriteLine("Eintrag(6) {0},{1} ist: {2:0.0000}", i, j, jagged[i][j]);
            }

        Console.Read();
    }
}
